% visualizes 2D distribution of the tSNE output

function Img = Visualize_tSNE_2DImage(y_out,dim1,dim2,indx)

dim3 = size(y_out,2);
if dim3==1
    n = dim1*dim2;
    D = zeros(n,1);
    D(indx) = y_out(:);  %index: positions where the tSNE was applied
    F1 = reshape(D(:),[dim1 dim2]);
    figure,imagesc(F1);
    Img = F1;
elseif dim3==2
    n = dim1*dim2;
    D = zeros(n,2);
    D(indx,1) = y_out(:,1);  %index: positions where the tSNE was applied
    D(indx,2) = y_out(:,2);
    F1 = reshape(D(:,1),[dim1 dim2]);
    F2 = reshape(D(:,2),[dim1 dim2]);
%     figure,imagesc(F1); figure,imagesc(F2);
    Img(:,:,1) = F1;
    Img(:,:,2) = F2;
    Img(:,:,3) = 0;
    figure,imshow(Img);
else 
    n = dim1*dim2;
    D = zeros(n,3);
    D(indx,1) = y_out(:,1);  %index: positions where the tSNE was applied
    D(indx,2) = y_out(:,2);
    D(indx,3) = y_out(:,3);
    F1 = reshape(D(:,1),[dim1 dim2]);
    F2 = reshape(D(:,2),[dim1 dim2]);
    F3 = reshape(D(:,3),[dim1 dim2]);
%     figure,imagesc(F1); figure,imagesc(F2);figure,imagesc(F3);
    RGB(:,:,1) = F1;
    RGB(:,:,2) = F2;
    RGB(:,:,3) = F3; 
    Img = RGB;
    figure, imshow(RGB);
end